﻿var addThemeToLibrary = {
    context: $(".v-addThemeToLibraryModel"),
    initializeAutoComplete: function () {
        $("#DefaultCategoryName", addThemeToLibrary.context).a4autocomplete({
            valueProperty: "Id",
            labelProperty: "Name",
            data: categories,
            altValueField: $("#DefaultCategoryId", addThemeToLibrary.context)
        });
    },
    bindEvents: function () {
        addThemeToLibrary.context.on("click", ".h-cancelButton", function () {
            modalDialog.close();
        });
        addThemeToLibrary.context.on("click", ".h-submitButton", function () {
            var categoryId = $("#DefaultCategoryId", addThemeToLibrary.context).val();
            var name = $(".v-nameInput", addThemeToLibrary.context).val();
            var themeId = $("#ThemeId", addThemeToLibrary.context).val();
            var useS2 = $("#UseS2", addThemeToLibrary.context).val();

            if (name && categoryId) {
                a4.callServerMethod(a4.getAction("TemplateExists", "SurveyTemplates", "Library"), { "name": name },
                    function (result) {
                        if (result == false) {
                            addThemeToLibrary.launchSaveTheme(categoryId, name, themeId, useS2);
                        }
                        else {
                            modalDialog.showConfirmDialog(confirmOverwriteResources, function () {
                                addThemeToLibrary.launchSaveTheme(categoryId, name, themeId, useS2);
                            }, 250, 500, true);
                        }
                    });
            }
            else {
                a4.showErrorMessage(resources.saveThemeToLibraryErrorMessage);
            }
        });
    },
    launchSaveTheme: function (categoryId, name, themeId, useS2) {
        var themeEditor = a4.parent().themeEditor;
        var projectId = themeEditor ? themeEditor.projectId : 0;
        var moduleId = themeEditor ? themeEditor.moduleId : 0;

        var params = {
            "themeId": themeId,
            "projectId": projectId,
            "moduleId": moduleId,
            "name": name,
            "useS2": useS2,
            "categoryId": categoryId
        };

        var confirmMessage = resources.saveThemeToLibraryConfirmMessage;

        a4.callServerMethod(a4.getAction("SaveTemplate", "SurveyTemplates", "Library"), params,
            function (result) {
                if (themeEditor)
                    themeEditor.saveToLibraryComplete(categoryId);

                modalDialog.close();

                a4.parent().a4.showSuccessMessage(confirmMessage, 2000);
            });
    }
};

$(document).ready(function () {
    if (addThemeToLibrary.context.length > 0) {
        addThemeToLibrary.initializeAutoComplete();
        addThemeToLibrary.bindEvents();
    }
});